/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render.item;

import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.util.EntityRenderHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1160;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_5617;
import org.jetbrains.annotations.Nullable;

public class ItemRenderableAutomobile
implements RenderableAutomobile {
    private final AutomobileData reader;
    private final Map<class_2960, class_3879> frameModelCache = new HashMap<class_2960, class_3879>();
    private final Map<class_2960, class_3879> wheelModelCache = new HashMap<class_2960, class_3879>();
    private final Map<class_2960, class_3879> engineModelCache = new HashMap<class_2960, class_3879>();
    private class_3879 emptyRearAttModel;
    private class_3879 emptyFrontAttModel;

    public ItemRenderableAutomobile(AutomobileData reader) {
        this.reader = reader;
        EntityRenderHelper.registerContextListener(ctx -> {
            this.frameModelCache.clear();
            this.wheelModelCache.clear();
            this.engineModelCache.clear();
            this.emptyRearAttModel = null;
            this.emptyFrontAttModel = null;
        });
    }

    @Override
    public AutomobileFrame getFrame() {
        return this.reader.getFrame();
    }

    @Override
    public AutomobileEngine getEngine() {
        return this.reader.getEngine();
    }

    @Override
    public AutomobileWheel getWheels() {
        return this.reader.getWheel();
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return null;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return null;
    }

    @Override
    public class_3879 getFrameModel(class_5617.class_5618 ctx) {
        if (!this.frameModelCache.containsKey(this.reader.getFrame().getId())) {
            this.frameModelCache.put(this.reader.getFrame().getId(), this.reader.getFrame().model().model().apply(ctx));
        }
        return this.frameModelCache.get(this.reader.getFrame().getId());
    }

    @Override
    public class_3879 getWheelModel(class_5617.class_5618 ctx) {
        if (!this.wheelModelCache.containsKey(this.reader.getWheel().getId())) {
            this.wheelModelCache.put(this.reader.getWheel().getId(), this.reader.getWheel().model().model().apply(ctx));
        }
        return this.wheelModelCache.get(this.reader.getWheel().getId());
    }

    @Override
    public class_3879 getEngineModel(class_5617.class_5618 ctx) {
        if (!this.engineModelCache.containsKey(this.reader.getEngine().getId())) {
            this.engineModelCache.put(this.reader.getEngine().getId(), this.reader.getEngine().model().model().apply(ctx));
        }
        return this.engineModelCache.get(this.reader.getEngine().getId());
    }

    @Override
    public class_3879 getRearAttachmentModel(class_5617.class_5618 ctx) {
        if (this.emptyRearAttModel == null) {
            this.emptyRearAttModel = RearAttachmentType.EMPTY.model().model().apply(ctx);
        }
        return this.emptyRearAttModel;
    }

    @Override
    public class_3879 getFrontAttachmentModel(class_5617.class_5618 ctx) {
        if (this.emptyFrontAttModel == null) {
            this.emptyFrontAttModel = FrontAttachmentType.EMPTY.model().model().apply(ctx);
        }
        return this.emptyFrontAttModel;
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getSteering(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return 0.0f;
    }

    @Override
    public boolean engineRunning() {
        return false;
    }

    @Override
    public int getBoostTimer() {
        return 0;
    }

    @Override
    public int getTurboCharge() {
        return 0;
    }

    @Override
    public long getTime() {
        return 0L;
    }

    @Override
    public boolean automobileOnGround() {
        return true;
    }

    @Override
    public boolean debris() {
        return false;
    }

    @Override
    public class_1160 debrisColor() {
        return new class_1160();
    }
}

